/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: socketsource.h,v 1.3.2.2 2003/05/27 17:18:56 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_SOCKET_SOURCE_H_INCLUDED
#define ZORP_SOCKET_SOURCE_H_INCLUDED

#include <zorp/stream.h>
#include <zorp/zorplib.h>
#include <zorp/io.h>

#ifdef G_OS_WIN32
#  include <winsock2.h>
#  define Z_SOCKEVENT_READ    FD_READ
#  define Z_SOCKEVENT_WRITE   FD_WRITE
#  define Z_SOCKEVENT_PRI     FD_PRI
#  define Z_SOCKEVENT_ACCEPT  FD_ACCEPT 
#  define Z_SOCKEVENT_CONNECT FD_CONNECT
#  define Z_SOCKEVENT_HUP     FD_CLOSE
#else
#  define Z_SOCKEVENT_READ    G_IO_IN
#  define Z_SOCKEVENT_WRITE   G_IO_OUT
#  define Z_SOCKEVENT_PRI     G_IO_PRI
#  define Z_SOCKEVENT_ACCEPT  G_IO_IN
#  define Z_SOCKEVENT_CONNECT G_IO_OUT
#  define Z_SOCKEVENT_HUP     G_IO_HUP
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _ZSocketSource
{
  GSource super;
  GIOCondition cond;
  GPollFD poll;
  gint timeout_time;
  gboolean suspended;
  gboolean timed_out;
#ifdef G_OS_WIN32
  SOCKET fd;
  gboolean acceptevent;
#endif
} ZSocketSource;

static inline gboolean
z_socket_source_is_suspended(GSource *s)
{
  return ((ZSocketSource *) s)->suspended;
}

typedef gboolean (*ZSocketSourceFunc)(gboolean timed_out, gpointer data);

GSource *z_socket_source_new(gint fd, GIOCondition cond, gint timeout);
void z_socket_source_suspend(GSource *);
void z_socket_source_resume(GSource *);

#ifdef __cplusplus
}
#endif

#endif
